Game_Interpreter.prototype.command103 = function() { //Input Number
	if (ConfigManager.touchbuttons) {
		$gameScreen.showPicture(456, "zBtnBack", 0, 0, 0, 100, 100, 255, 0);
	}
	else {
		$gameScreen.erasePicture(456);
	}
	
	if (!Utils.isMobileDevice()) {
		$gameMessage.setFaceImage("", 0);
		$gameMessage.setBackground(2);
		$gameMessage.setPositionType(2);
		$gameMessage.addText("Use numpad to input numbers. Press [Enter] when finished.\n\nPress [←][↑][→][↓] or mouse-click for manual character entry.\n\nWhile in manual character entry, you may press [Esc] to return to numpad input.``");
		this.setWaitMode('message');
	}
	
	SceneManager.push(Scene_Number);
	SceneManager.prepareNextScene(this._params[0], this._params[1]);
    return true;
};


function Scene_Number() {
    this.initialize.apply(this, arguments);
}

Scene_Number.prototype = Object.create(Scene_MenuBase.prototype);
Scene_Number.prototype.constructor = Scene_Number;

Scene_Number.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
};

Scene_Number.prototype.prepare = function(numId, maxLength) {
    this._numId = numId;
    this._maxLength = maxLength;
};

Scene_Number.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
	$gameSwitches.setValue(133, false) //is number input
    this.createEditWindow();
    this.createInputWindow();
};

Scene_Number.prototype.start = function() {
    Scene_MenuBase.prototype.start.call(this);
    this._editWindow.refresh();
};

Scene_Number.prototype.createEditWindow = function() {
    this._editWindow = new Window_NumEdit($gameActors.actor(4), this._maxLength);
    this.addWindow(this._editWindow);
};

Scene_Number.prototype.createInputWindow = function() {
    this._inputWindow = new Window_NumInput(this._editWindow);
    this._inputWindow.setHandler('ok', this.onInputOk.bind(this));
    this._inputWindow.setHandler('cancel', this.onInputCancel.bind(this));
    this.addWindow(this._inputWindow);
};

Scene_Number.prototype.onInputOk = function() {
	$gameVariables.setValue(this._numId, parseInt(this._editWindow.name()))
    this.popScene();
	if (ConfigManager.touchbuttons) {
		$gameScreen.showPicture(456, "zBtnMenu", 0, 0, 0, 100, 100, 255, 0);
	}
	else {
		$gameScreen.erasePicture(456);
	}
};

Scene_Number.prototype.onInputCancel = function() {
	$gameVariables.setValue(this._numId, "x")
    this.popScene();
	if (ConfigManager.touchbuttons) {
		$gameScreen.showPicture(456, "zBtnMenu", 0, 0, 0, 100, 100, 255, 0);
	}
	else {
		$gameScreen.erasePicture(456);
	}
};



function Window_NumEdit() {
    this.initialize.apply(this, arguments);
}

Window_NumEdit.prototype = Object.create(Window_Base.prototype);
Window_NumEdit.prototype.constructor = Window_NumEdit;

Window_NumEdit.prototype.initialize = function(actor, maxLength) {
    var width = 130
    var height = this.windowHeight();
		
    var x = 343
    var y = 26
		
    Window_Base.prototype.initialize.call(this, x, y, width, height);
    this._actor = $gameActors.actor(4)
    this._name = this._actor.name().slice(0, this._maxLength);
    this._index = this._name.length;
    this._maxLength = maxLength;
    this._defaultName = this._name;
    this.deactivate();
    this.refresh();
};

Window_NumEdit.prototype.windowHeight = function() {
    return this.fittingHeight(1);
};

Window_NumEdit.prototype.name = function() {
    return this._name;
};

Window_NumEdit.prototype.restoreDefault = function() {
    this._name = this._defaultName;
    this._index = this._name.length;
    this.refresh();
    return this._name.length > 0;
};

Window_NumEdit.prototype.add = function(ch) {
    if (this._index < this._maxLength) {
        this._name += ch;
        this._index++;
        this.refresh();
        return true;
    } else {
        return false;
    }
};

Window_NumEdit.prototype.back = function() {
    if (this._index > 0) {
        this._index--;
        this._name = this._name.slice(0, this._index);
        this.refresh();
        return true;
    } else {
        return false;
    }
};

Window_NumEdit.prototype.charWidth = function() {
    var text = $gameSystem.isJapanese() ? '\uff21' : 'A';
    return this.textWidth(text);
};

Window_NumEdit.prototype.itemRect = function(index) {
    return {
//        x: (index * this.charWidth()) + this.contentsWidth()/2 - 44,
        x: (index * this.charWidth()) - ((this._maxLength / 2) * this.charWidth()) + 57,
        y: 0,
        width: this.charWidth(),
        height: this.lineHeight()
    };
};

Window_NumEdit.prototype.underlineRect = function(index) {
    var rect = this.itemRect(index);
    rect.x++;
    rect.y += rect.height - 4;
    rect.width -= 2;
    rect.height = 2;
    return rect;
};

Window_NumEdit.prototype.underlineColor = function() {
    return this.normalColor();
};

Window_NumEdit.prototype.drawUnderline = function(index) {
    var rect = this.underlineRect(index);
    var color = this.underlineColor();
    this.contents.paintOpacity = 125;
    this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, color);
    this.contents.paintOpacity = 255;
};

Window_NumEdit.prototype.drawChar = function(index) {
    var rect = this.itemRect(index);
    this.resetTextColor();
    this.drawText(this._name[index] || '', rect.x, rect.y);
};

Window_NumEdit.prototype.refresh = function() {
    this.contents.clear();
    for (var i = 0; i < this._maxLength; i++) {
        this.drawUnderline(i);
    }
    for (var j = 0; j < this._name.length; j++) {
        this.drawChar(j);
    }
    var rect = this.itemRect(this._index);
    this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
};



function Window_NumInput() {
    this.initialize.apply(this, arguments);
}

Window_NumInput.prototype = Object.create(Window_Selectable.prototype);
Window_NumInput.prototype.constructor = Window_NumInput;
Window_NumInput.NUMBERS =
        [ '7','8','9',
          '4','5','6',
          '1','2','3',
          'Del','0','OK'];

		  
Window_NumInput.prototype.initialize = function(editWindow) {
    var x = 250
    var y = 84

    var width = 316
    var height = 378
	
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._editWindow = editWindow;
    this._page = 0;
    this._index = 4;
    this.refresh();
    this.updateCursor();
    this.activate();
};

Window_NumInput.prototype.windowHeight = function() {
    return this.fittingHeight(1);
};

Window_NumInput.prototype.table = function() {
	return [Window_NumInput.NUMBERS];
};

Window_NumInput.prototype.maxCols = function() {
    return 3;
};

Window_NumInput.prototype.maxItems = function() {
    return 12;
};

Window_NumInput.prototype.character = function() {
    return (this._index < 9 || this._index == 10) ? this.table()[this._page][this._index] : '';
};

Window_NumInput.prototype.isOk = function() {
    return this._index === 11;
};

Window_NumInput.prototype.isDel = function() {
    return this._index === 9;
};

Window_NumInput.prototype.itemRect = function(index) {
    return {
        x: (index % 3 * 50) * 2,
        y: (Math.floor(index / 3) * this.lineHeight()) * 2.5,
        width: 50 * 2,
        height: this.lineHeight() * 2.5
    };
};

Window_NumInput.prototype.refresh = function() {
    var table = this.table();
    this.contents.clear();
    this.resetTextColor();
    for (var i = 0; i < 12; i++) {
        var rect = this.itemRect(i);
        rect.x += 3;
        rect.width -= 6;
        this.drawText(table[this._page][i], rect.x, rect.y + 27, rect.width, 'center');
    }
};

Window_NumInput.prototype.updateCursor = function() {
    var rect = this.itemRect(this._index);
    this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
};

Window_NumInput.prototype.isCursorMovable = function() {
    return this.active;
};

Window_NumInput.prototype.cursorDown = function(wrap) {
    if (this._index < 8 || wrap) {
        this._index = (this._index + 3) % 12;
    }
};

Window_NumInput.prototype.cursorUp = function(wrap) {
    if (this._index >= 3 || wrap) {
        this._index = (this._index + 9) % 12;
    }
};

Window_NumInput.prototype.cursorRight = function(wrap) {
    if (this._index % 3 < 2) {
        this._index++;
    } else if (wrap) {
        this._index -= 2;
    }
};

Window_NumInput.prototype.cursorLeft = function(wrap) {
    if (this._index % 3 > 0) {
        this._index--;
    } else if (wrap) {
        this._index += 2;
    }
};

Window_NumInput.prototype.cursorPagedown = function() {};

Window_NumInput.prototype.cursorPageup = function() {};

Window_NumInput.prototype.processCursorMove = function() {
    var lastPage = this._page;
    Window_Selectable.prototype.processCursorMove.call(this);
    this.updateCursor();
    if (this._page !== lastPage) {
        SoundManager.playCursor();
    }
};

Window_NumInput.prototype.processHandling = function() {
    if (this.isOpen() && this.active) {
        if (Input.isTriggered('shift')) {
            this.processJump();
        }
        if (Input.isRepeated('cancel')) {
            this.processBack();
        }
        if (Input.isRepeated('ok')) {
            this.processOk();
        }
    }
};

Window_NumInput.prototype.isCancelEnabled = function() {
    return true;
};

Window_NumInput.prototype.processCancel = function() {
    this.processBack();
};

Window_NumInput.prototype.processJump = function() {
    if (this._index !== 11) {
        this._index = 11;
        SoundManager.playCursor();
    }
};

Window_NumInput.prototype.processBack = function() {
    if (this._editWindow.back()) { //calls editwindow's back function
		SoundManager.playCancel();
    }
	else {
		if (Input.isPressed('cancel')) {
			SoundManager.playCancel();
			this.callHandler('cancel');
		}
		else {
			SoundManager.playBuzzer();
		}
	}
};

Window_NumInput.prototype.processOk = function() {
    if (this.character()) {
        this.onNameAdd();
    } else if (this.isDel()) {
        this.processBack();
    } else if (this.isOk()) {
        this.onNameOk();
    }
};

Window_NumInput.prototype.onNameAdd = function() {
    if (this._editWindow.add(this.character())) {
        SoundManager.playOk();
    } else {
        SoundManager.playBuzzer();
    }
};

Window_NumInput.prototype.onNameOk = function() {
    if (this._editWindow.name() === '') {
        if (this._editWindow.restoreDefault()) {
            SoundManager.playOk();
        } else {
            SoundManager.playBuzzer();
        }
    } else {
        SoundManager.playOk();
        this.callOkHandler();
    }
};






